;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;; $Source: /home/geddis/archive/cvs/scripts/dtp/lisp/types.lisp,v $
;;; $Id: types.lisp,v 1.1 2004/07/15 04:22:05 geddis Exp $
;;;
;;; (c) Copyright 1994-2004 Don Geddis.  All rights reserved.
;;;
;;; System:		Don's Theorem Prover (DTP)
;;; Written by:		Don Geddis <don@geddis.org>
;;;
;;;----------------------------------------------------------------------------

(in-package "DTP")

;;;----------------------------------------------------------------------------

(deftype binding-list ()
  "Mapping from variables to bindings, implemented as a list of conses"
  'list )

(deftype binding ()
  "A single map, assigning a variable to a value, implemented as a cons"
  'cons )

;;;----------------------------------------------------------------------------

(deftype boolean ()
  "T or NIL"
  '(or (eql t) null) )

;;;----------------------------------------------------------------------------

(deftype natural-number ()
  "Integer greater than or equal to zero"
  '(integer 0 *) )

;;;----------------------------------------------------------------------------
