;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;; $Source: /home/geddis/archive/cvs/scripts/dtp/lisp/residue.lisp,v $
;;; $Id: residue.lisp,v 1.1 2004/07/15 04:22:05 geddis Exp $
;;;
;;; (c) Copyright 1994-2004 Don Geddis.  All rights reserved.
;;;
;;; System:		Don's Theorem Prover (DTP)
;;; Written by:		Don Geddis <don@geddis.org>
;;;
;;;----------------------------------------------------------------------------

(in-package "DTP")

;;;----------------------------------------------------------------------------
;;;
;;;	Public

(defun residue-answer (subgoal assumable)
  (with-slots (literal) subgoal
    (when (literal-instance assumable literal)
      (make-answer
       :residue (list literal)
       :justification (make-res-justification :assumable assumable)
       :proof *proof* )
      )))

;;;----------------------------------------------------------------------------

(defun residue-merge (residue1 residue2)
  (let ((new-res (append residue1 residue2)))
    (if (proof-consistency-check *proof*)
	(if (funcall (proof-consistency-check *proof*) new-res)
	    new-res
	  :not-a-residue )
      new-res )))

;;;----------------------------------------------------------------------------

(defun residue-equal-p (residue1 residue2)
  (set-equal residue1 residue2 #'literal-equal-p) )

;;;----------------------------------------------------------------------------

(defun residue-instance? (instance general)
  "True IFF the INSTANCE residue is more specific than (or equal to) GENERAL"
  (subsetp general instance :test #'literal-instance?) )

;;;----------------------------------------------------------------------------
