;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;; $Source: /home/geddis/archive/cvs/scripts/dtp/lisp/dtp.lisp,v $
;;; $Id: dtp.lisp,v 1.1 2004/07/15 04:22:05 geddis Exp $
;;;
;;; (c) Copyright 1994-2004 Don Geddis.  All rights reserved.
;;;
;;; System:		Don's Theorem Prover (DTP)
;;; Written by:		Don Geddis <don@geddis.org>
;;;
;;;----------------------------------------------------------------------------
;;;
;;;	Version history
;;;	  3.00 07/14/04	Converted code to ANSI CL (under CMUCL)
;;;	  2.13 03/29/04 New contact info, remove 'DFG' specialization
;;;	  2.12 03/27/95	Term simplification on answers (as well as literals)
;;;	  2.11 02/14/95 Fixed pure literal elim + proc attachment interaction
;;;	  2.10          Simplified "view" proof figures
;;;	  2.09          Re-introduced forking conjunctions
;;;	  2.08          Merged answers and reduction answers
;;;	  2.07          Iteration, on subgoal and function depth
;;;	  2.06          Simplified conjunction solving (removed forward inf)
;;;	  2.05          TPTP Library tools
;;;	  2.04          General "view" tool on proofs and answers
;;;	  2.03          Reduction check at conjunct instead of subgoal
;;;	  2.02          Depth limits and iteration (Broken implementation)
;;;	  2.01          Corrected reduction inference combined with caching
;;;	  2.00          Subgoaling inference system
;;;	  1.00     1994 Resolution-based inference system
;;;
;;;----------------------------------------------------------------------------
;;;
;;;	Documentation Notes
;;;
;;;	Exported functions are intended to be called by users.  All other
;;;	functions and symbols are intended to be internal.
;;;
;;;	Many files have a "public" and a "private" section.  Functions defined
;;;	in the "private" section are ONLY called by functions within the same
;;;	file.  All functions called by routines in other files are placed in
;;;	the "public" section.
;;;
;;;	Function names: Both Common Lisp and Scheme conventions are
;;;	occassionally followed.  Thus a suffix of "-P" or "?" indicates a
;;;	predicate (testing for a condition).  A prefix of "N" or a suffix
;;;	of "!" indicates a destructive function, which may alter its arguments.
;;;
;;;----------------------------------------------------------------------------

(in-package "COMMON-LISP-USER")

(eval-when (compile eval load)
  (defpackage "DTP" (:use "COMMON-LISP")) )

(in-package "DTP")

;;;----------------------------------------------------------------------------

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defparameter *dtp-major-version* 3)
  (defparameter *dtp-minor-version* 0)
  )

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defparameter *dtp-version*
      (format nil "~D.~2,'0D (July 14, 2004)"
	      *dtp-major-version* *dtp-minor-version* ))
  (export '(*dtp-version*)) )


(eval-when (:compile-toplevel :load-toplevel :execute)
  (format t "~&DTP version ~A~%" *dtp-version*) )

;;;----------------------------------------------------------------------------

(eval-when (:compile-toplevel :load-toplevel :execute)
  (defparameter *dtp-directory* "/home/geddis/scripts/dtp/")
  (defparameter *dtp-logic-directory* "/home/geddis/scripts/dtp/logic/")
  (export '(*dtp-directory* *dtp-logic-directory*)) )

;;;----------------------------------------------------------------------------

;;(require :mk-defsystem)

(make:defsystem :dtp
    :source-pathname "/home/geddis/scripts/dtp/lisp/"
    :binary-pathname "/home/geddis/scripts/dtp/lisp/"
    :components
    ((:module :dtp-data-structures
	      :source-pathname ""
	      :components
	      ((:file "types")
	       (:file "structures")
	       (:file "classes") ))
     (:module :variables
	      :source-pathname ""
	      :components
	      ((:file "variables")) )
     (:module :dtp-extensions
	      :source-pathname ""
	      :components
	      ((:file "internals")
               ;;(:file "defsystem")
	       ))
     (:module :dtp-unification
	      :source-pathname ""
	      :components
	      ((:file "symbols")
	       (:file "bindings")
	       (:file "binding-dag")
	       (:file "match")
	       (:file "cnf") ))
     (:module :dtp-kb
	      :source-pathname ""
	      :components
	      ((:file "literals")
	       (:file "clauses")
	       (:file "labels")
	       (:file "answers")
	       (:file "database") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     (:module :dtp-inference
	      :source-pathname ""
	      :components
	      ((:file "misc-inference")
	       (:file "terms")
	       (:file "subgoals")
	       (:file "conjunctions")
	       (:file "fork")
	       (:file "conjunct")
	       (:file "backtrack")
	       (:file "caching")
	       (:file "residue")
	       (:file "ordering")
	       (:file "prover") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     (:module :dtp-view
	      :source-pathname ""
	      :components
	      ((:file "view")
	       (:file "dotify")
	       (:file "textify")
	       (:file "below") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     (:module :dtp-misc
	      :source-pathname ""
	      :components
	      ((:file "hierarchy")
	       (:file "output")
	       (:file "file")
	       (:file "test")
	       (:file "epikit-dtp")
	       (:file "tptp")
	       (:file "figures") )
	      :depends-on (:dtp-data-structures :dtp-extensions) )
     ))

;;;----------------------------------------------------------------------------

(defun compile-dtp ()
  (make:operate-on-system :dtp 'compile :verbose t) )

(defun load-dtp ()
  (make:operate-on-system :dtp 'load :verbose t) )

(eval-when (:load-toplevel :execute)
  (load-dtp) )

;;;----------------------------------------------------------------------------
